# Version 2.2.0
## Installation

ACGtk now only optionally depends on `cairo2` opam package.

Compatible Ocaml versions: greater than `5.2.0`.

## The `acg` interpreter:
+ Support parsing for almost linear grammars
+ Add a `-b` or `--build=info` option to output whether `acg` supports svg output.
+ Improve readability and syntax compliance of Datalog rules output by the `idb` command
+ Add a `comment` parameter to the `check`, `realize`, and `parse` commands ([db27da0](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/db27da0))
+ Add a `--browser` option to launch the browser version if available ([e9d116f](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/e9d116f))
+ Fix various bugs:
  + meaningful error message when the interpretation of `type` parameter of a `parse` or a `query` ([776d80e](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/776d80e)) function does not match the type of the input term. Fixes #45.
  + check that binder types match `('a ?> 'b) ?> 'c` (where `?>` can be either `->` or `=>`) ([3b7984fc](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/3b7984fc) and [a493313](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/a493313)). Fixes #48.
  + Check that all the lexicons share the same abstract signature in a realize command ([ba33f63](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/ba33f63)). Fixes #46.
  + Fix output of terms using infix symbols or binders ([95778ea](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/95778ea))
  + Fix missing syntax error message when piping commands ([ca0cbe8](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/ca0cbe8)). Fixes #36.
  + Fix and improve checks for the definition of composed lexicons with the `compose` command ([19e1ea2](https://gitlab.inria.fr/ACG/dev/ACGtk/-/commit/19e1ea2)). Fixes #49.
  
## `acgtk-browser`
A Javascript version of `acg`, called `acgtk-browser` is now available (but not distributed with `opam`). It is generated using `js_of_ocaml` and aimed to [run as client in browsers](https://acg.gitlabpages.inria.fr/dev/ACGtk/web/).

    The documentation has been updated accordingly. Main features: From the web browser:
    + Write or upload lexicons and signatures,
    + Compile lexicons and signatures.
    + Run `acg` commands using the defined signatures and lexicons.

# Version 2.1.0

## The `acg` interpreter:
+ Fix bug when enumerating parsing solutions when dealing with very ambiguous grammars
+ Add a `stack_limit` option to the `parse` command to fine-tune sorting of parsing solutions
+ Add a message when the type of the term to parse is not an interpretation of the distinguished type given as parameter to the `parse` command
+ Fix various bugs with `acg` commands

# Version 2.0.0
## Various bug fixes

## The `acg` interpreter:
### Changes
+ Completely new command langage. **Warning:** It breaks backward compatibility. For a list of the available commands, run `acg` and `help`. See https://acg.gitlabpages.inria.fr/dev/ACGtk/release/acgtk/scripting.html.
+ Adds completion capabilities to the command language.
+ Improve sorting the terms to be printed as result of a `parse` command.
+ Allow parsing with magic set rewritten programs (experimental)

### Command line arguments
+ `-c` or -`--colors`: to control colors in the output. Use `yes` to enable colors, `no` to disable them, or `auto` to enable them if the output is a TTY.
+ `-d` or `--debug`: starts `acg` in debug mode: it will record and print backtraces of uncaught exceptions.
+ `-i` or `--interacgtive`: starts interactive mode even if script files are provided, i.e.,  after running the script, move to interactive mode.
+ `-I` or `--include`: to add directories where to look for object and data files.
+ `-m` or `--magic`: Toggle on using magic set rewritten programs for parsing (experimental feature). When set, parsing commands using magic rewritten programs (if available in object files generated by `acgc`).
+ `-r` or `--seed`: set a seed value to use for initialization of the random number generator (useful for the `list-terms` command of `acg`). If this paramenter is not provided, the random number generator will be initialized with a random seed.
+ `--realize`: sets the json config rendering file for the svg generated (by the realize command) files.
+ `-s` or `--step-by-step`: runs scripts step by step. This means that the execution will be paused before each command, and after printing the result of commands which return terms. Also, this will print the executed script during the execution."
+ `--version` to get the version number of the software.

## The `acgc` compiler:
### acg data language
+ Now use UTF-8 symbols
+ New syntax for identifiers, operators and binders. See https://acg.gitlabpages.inria.fr/dev/ACGtk/release/acgtk/users.html#identifiers and https://acg.gitlabpages.inria.fr/dev/ACGtk/release/acgtk/users.html#symbols.

### Command line arguments
+ `-i` flag and interactive mode are removed. Command line arguments are now:
  + `-c` or -`--colors`: to control colors in the output. Use `yes` to enable colors, `no` to disable them, or `auto` to enable them if the output is a TTY.
  + `-d` or `--debug`: starts `acgc` in debug mode: it will record and print backtraces of uncaught exceptions.
  + `-I` or `--include`: to add directories where to look for object and data files
  + `-m` or `--magic`: toggles on generating magic programs. This is an experimental feature. Parsing with magic will be available in `acg`. Be aware that using this option may cause generated object files to be very large.
  + `-o` or `--output`: to output the result in a specific file (instead of a file `file.acgo` id `file.acg` was the last file provided as argument.
  + `-v` or `--verbosity`: verbosity level. For the moment, only 0 (when the flag is not provided) or 1 (default when the flag is provided) are available. If the level is greater, than all debug information are printed. Be aware that positional argument(s) (files) may need to be separated by "--" if no other optional argument is provided after "-v".
  + `--version` to get the version number of the software.

# Version 1.5.4
## Various bug fixes

## The `acg.opt`/`acg` interpreter:
+ Add a `all-parse` command to get all the possible parses (possibly infinitely many) of an object term.

# Version 1.5.3
## Various bug fixes

## Prepare Datalog prover extension to handle states and weights for probabilistic ACG

# Version 1.5.2
## Fixes build dependency to menhir generated messages

## Various bug fixes

# Version 1.5.1
## Remove dependency to the ocf package

## Arguments of `acg` and `acgc` are now handled by the Cmdliner library
* For `acgc`, arguments are now:
1. `--version` (instead of `-version`) to get the version number of the software
2. `-o` and `--output` (instead of only `-o`) to output the result in a specific file
3. `-I` and `--include` (instead of only `-I`) to add directories where to look for files
4. `-i` and `--interactive` (instead of only `-i`) to enter the interaction loop
5. `--help` (instead of `-help` and `--help`) to get help
* For `acg`, arguments are now:
1. `--version` (instead of `-version`) to get the version number of the software
2. `-I` and `--include` (instead of only `-I`) to add directories where to look for files
3. `--nc` and `--no-color` (instead of `-nc`) to toggle off output coloring
4. `--npp` and `--no-pretty-printing` (instead of `-npp`) to toggle off output pretty printing
5. `--nsvg` and `--no-svg` (instead of `-nsvg`) to toggle off svg output of the `realize` acg command
6. `--realize` (instead of `-realize`) to set the configuration file with the rendering engines
7. `--svg` (instead of `-svg`) to set the file name of the svg output of the `realize` acg command
8. `--help` (instead of `-help` and `--help`) to get help

# Version 1.5.0
## The `acgc.opt`/`acgc` compiler and the `acg.opt`/`acg` interpreter:
* Removed the dependency to BOLT (replaced by Logs) and dypgen (replaced by menhir)
* Some syntax changes:
  1. Prefix operators have the highest priority
  2. Application has precedence over infix operators
  3. An associativity property (none, left, right) can be set to infix operators (left is the default), and a precedence level as well. See the associativity and the precedence section in the [README](README.me).
  4. Infix operator can be used as usual constant by surrounding then with left and right parenthesis, so that `t SYM u` = `(SYM) t u`

# Version 1.4.0
## The `acgc.opt`/`acgc` compiler and the `acg.opt`/`acg` interpreter:
* Improved performance by better logging management (for debug)
* Extended set of latin1 characters allowed in .acg files

# Version 1.3.3
## The `acgc.opt`/`acgc` compiler and the `acg.opt`/`acg` interpreter:
* the build process now relies on `jbuilder`


# Version 1.3.1
## The `acg.opt`/`acg` interpreter
* Bug fix: constants that were given two interpretations in a lexicon (only the last one is available) generated two rules in the corresponding datalog program (hence possibly several parses)
* Bug fix: when an object constant was the direct interpretation of an abstract constant, parsing this object constant raised an exception
* an option `-svg filename` is added to `./acg` and `./acg.opt` to allow the user to provide another name than the default `realize.svg` to the svg output file.

## Configuration and opam file
* an option `--disable-warning-as-errors` to the `.configure` script in order to make opam compile without the `-warn-error A` option.

# Version 1.3.0
## The `acg.opt`/`acg` interpreter
* Colors and link between signature and rendering engines are now defined in a json configuration file. The option to load the configuration is `-realize`.

# Version 1.2
## The `acg.opt`/`acg` interpreter
* Added the generation of a `realize.svg` file when the `realize` command of `acg` is invoked. Colors and link between signature and rendering engines are hard-coded.
* An option is added to toggle of the `realize.svg` file generation (takes a bit of time)

# Version 1.1
## The `acgc.opt`/`acgc` compiler and the `acg.opt`/`acg` interpreter:
* Fixed severe bug that prevented finding some parses and sometimes caused a `Fatal Error`
* Added a control on the compiler version that generated the object (`.acgo`) files. The version has to be the same as the current version of the compiler or of the interpreter that is being used.

## The `acgc.opt`/`acgc` compiler:
* added a `nl_lexicon` keyword that causes the interpretation of any functional type (`->` or `=>`) of the abstract signature to be interpreted by the intuitionistic arrow `=>` in the object signature.

	Accordingly, the interpretation should use `Lambda`.

## The `acg.opt`/`acg` interpreter:
* Improved terminal output (colors and formatting)
* added a `-nc` option to disable colored outputs
* added a `-npp` option to disable formatting on the output

## The acg emacs mode
* improved handling of long files

# Version 1.0b
## The `acgc.opt`/`acgc` compiler:
* Now outputs an `file.acgo` file when compilation is successful
* Can declare a lexicon as the composition of two other lexicons using the following declaration:

	```
	lexicon lex_name = lex_name2 << lex_name1
	```

## The `acg.opt`/`acg` interpreter:
* Can load an acg object file using the command:
  ```
  load o file.acco;
  ```

* The `analyse` command is deprecated. It is replaced by:
  * A `check` command, prefixed by signatures, that typecheck the typing assignment of a term

	```
	Sig1 Sig2 check term:type;
	```
  * A `realize` command that must be preceded by lexicons and followed by the type assignment of a term. It checks that the term is well typed in the abstract signatures of the lexicons and compute its realizations through the lexicons.

	```
	Lex1 Lex2 realize term:type;
	```
  * A `parse` command has been added. It must be preceded with the name of a lexicon and it returns the antecedent by this lexicon of the input term with respect to some distinguished (atomic) type:

	```
	Lex parse object_term:distinguished_type;
	```

* A `query` command has been added. It follows the `parse` command syntax and it outputs the associated query and associated extensional database.
```
Lex query object_term:distinguished_type;
```

* A `idb` command has been added. It must be preceded with the name of a lexicon and it returns the intensional database associated with the lexicon
```
Lex idb;
```


## Current limitation:
* Only parse images of atomic types
* The result of parsing with non-linear lexicons is unspecified yet
