open UtilsLib
open DatalogLib
open Datalog_AbstractSyntax
open Logic.Lambda

module Log : Xlog.MyLOG
(** [Log] is the log module for Reduction *)

(** This module implements the reduction from ACG signatures and
    lexicons to datalog programs *)
module Make (Sg : module type of Signature.Data_Signature) : sig
  val generate_and_add_rule :
    abs_cst:string * Lambda.stype ->
    interpretation:(Lambda.term * Lambda.stype) ->
    abs_sig:Sg.t ->
    obj_sig:Sg.t ->
    update_fct:
      (Lambda.term ->
      string Utils.IntMap.t * Utils.StringSet.t ->
      string * (string Utils.IntMap.t * Utils.StringSet.t)) ->
    syms:string Utils.IntMap.t * Utils.StringSet.t ->
    Datalog.Datalog.Program.program ->
    AbstractSyntax.Rule.rule
    * Datalog.Datalog.Program.program
    * (string Utils.IntMap.t * Utils.StringSet.t)
  (** [generate_and_add_rule
      ~abs_cst:(name, dist_type)
      ~interpretation:(o_term, o_type)
      prog
      abs_sig
      obj_sig] returns a pair [(r,prog')] where:
      {ul
      {- [r] is the generated rule}
      {- [prog'] is [prog] where the rule [r] has been added}
      {- [name] is the abstract constant name from the abstract
      signature [abs_sig] that triggers the rule generation, and
      [dist_type] is its type}
      {- [o_term] is the interpretation of [name] according to some
      lexicon}
      {- [o_type] is its type (and should be the image by the same
      lexicon of [abs_cst]}
      {- [prog] is the current datalog program}
      {- [abs_sig] and [obj_sig] are the abstract signature and the
      object signature of some ACG.}} *)

  val edb_and_query :
    obj_term:Lambda.term ->
    obj_type:Sg.stype ->
    dist_type:Sg.stype ->
    ?adornment:MagicRewriting.Adornment.status list ->
    Datalog.Datalog.Program.program ->
    abs_sig:Sg.t ->
    obj_sig:Sg.t ->
    syms:string Utils.IntMap.t * Utils.StringSet.t ->
    AbstractSyntax.Predicate.predicate * Datalog.Datalog.Program.program
  (** [edb_and_query ~obj_term ~obj_type ~dist_type
      prog ~abs_sig ~obj_sig] returns a pair [(q,prog')] where:
      {ul
      {- [q] is the predicate corresponding to the query generated by
      the object term [obj_term] to parse}
      {- [prog'] is [prog] where the extensional database resulting
      from the reduction of the object term [obj_term] has been added}
      {- [obj_type] is the type of [obj_term] (only used for debugging
      information)}
      {- [dist_type] is the distinguished type of the ACG}
      {- [prog] is the current datalog program}
      {- [abs_sig] and [obj_sig] are the abstract signature and the
      object signature of some ACG.}} *)

end
