type location = Lexing.position * Lexing.position
type context = { file : string option; loc : location option }

module type MSG = sig
  type t

  val err : 'a Logs.log
  val warn : 'a Logs.log
  val to_string : t -> string
end

module Make (M : MSG) : sig
  type t

  type msg =
    | Msg_Only of M.t
    | Msg_and_Full_Location of (M.t * string option * location option)
    | Msg_and_Location of (M.t * location option)
    | Msg_in_Full_Context of M.t

  exception Stop

  val empty : context -> t
  val set_context : context -> t -> t
  val register : ?blocking:bool -> msg -> t -> t
  val issue_msg : ?filename:string -> ?location:location -> t -> t
end
