type basic_color =
  | Black
  | Red
  | Green
  | Yellow
  | Blue
  | Magenta
  | Cyan
  | White

type intensity =
  | Standard
  | High

type color = 
  | Code of (intensity * basic_color)
  | RGB of (int * int * int)

type style =
  | No
  | Bold
  | Faint
  | Italic
  | Underline
  | FG of color
  | BG of color

type style_tag =
  | Open of style
  | Close of style

module type SemTagSig =
  sig
    type tag
    val tags : (string * tag  * style list) list
  end

module type SemTagHandlerSig =
  sig
    type semtag
    val tag_to_name : semtag -> string
  end

module Make_Handler(S:SemTagSig)=
  struct
    type semtag = S.tag
    let tag_to_name tag =
      let name, _, _  = List.find (fun (_, t, _) -> tag = t) S.tags in
      name
  end

module type ActualRendererSig =
  sig
    val render : style list -> string -> string
    (** [render style s] returns a string rendering the style
        [style] *)
    
    val render_mark : style_tag list -> string
  (** [render_mark att s] returns a string rendering the sequence (in
      the same order) of attributes [att] *)
  end

