val bold_pp : Format.formatter -> string -> unit
                                              [@@alert deprecated "prefer using dedicated pp instead of using bold_pp"]
val blue_pp : Format.formatter -> string -> unit
                                              [@@alert deprecated "prefer using dedicated pp instead of using blue_pp"]
val red_pp : Format.formatter -> string -> unit
                                              [@@alert deprecated "prefer using dedicated pp instead of using red_pp"]
val green_pp : Format.formatter -> string -> unit
                                              [@@alert deprecated "prefer using dedicated pp instead of using green_pp"]
val magenta_pp : Format.formatter -> string -> unit
                                              [@@alert deprecated "prefer using dedicated pp instead of using magenta_pp"]
val yellow_pp : Format.formatter -> string -> unit
                                              [@@alert deprecated "prefer using dedicated pp instead of using yellow_pp"]

val app_pp : Format.formatter -> string -> unit
(** [app_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the application semantic tag <app> *)

val err_pp : Format.formatter -> string -> unit
(** [err_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the error semantic tag <err> *)

val warn_pp : Format.formatter -> string -> unit
(** [warn_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the warning semantic tag <warn> *)

val info_pp : Format.formatter -> string -> unit
(** [info_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the information semantic tag <info> *)

val debug_pp : Format.formatter -> string -> unit
(** [debug_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the debug semantic tag <debug> *)

val fun_pp : Format.formatter -> string -> unit
(** [fun_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <fun> *)

val sig_pp : Format.formatter -> string -> unit
(** [sig_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <sig> *)

val lex_pp : Format.formatter -> string -> unit
(** [lex_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <lex> *)

val term_pp : Format.formatter -> string -> unit
(** [terms_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <terms> *)

val arg_pp : Format.formatter -> string -> unit
(** [arg_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <arg> *)

val binary_pp : Format.formatter -> string -> unit
(** [bin_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <bin> *)

val err_text_pp : Format.formatter -> string -> unit
(** [err_text_pp ppf s] pretty prints the string [s] on the formatter [ppf]
    surrounded by the semantic tag <err_text> *)


val add_marking : render_mark:(Style.style_tag list -> string) -> Format.formatter -> unit
(** [add_marking ~render_mark fmt] makes [fmt] use semantic tags with
    marking, following the marking defined by [render_mark] *)
