(** A
   {{:https://erratique.ch/software/logs/doc/Logs/index.html#module-type-LOG}
   Logs.LOG} module that includes its source *)

module type MyLOG = sig
  include Logs.LOG

  val src : Logs.src
end

val stamp : Mtime_clock.counter -> Logs.Tag.set

val log_pairs :
  src:Logs.src ->
  Logs.level ->
  ((('a -> 'b -> 'c, Format.formatter, unit, unit) format4 ->
   ('d -> 'a) * 'd ->
   ('e -> 'b) * 'e ->
   'c) ->
  unit) ->
  unit

val setup_log : app:string -> render_mark:(Style.style_tag list -> string) -> ?colored:bool -> Logs.level -> Format.formatter -> unit
(** [setup_log ~app f l] sets the log level to [l] and provides the name
    [app] to the default application log, for the formatter [f]. *)

val setup_log_std : app:string -> render_mark:(Style.style_tag list -> string) -> ?colored:bool -> Logs.level -> unit
(** [setup_log ~app f l] sets the log level to [l] and provides the name
    [app] to the default application log, for the formatter [Format.std_formatter]. *)


module Make (_ : sig
  val name : string
end) : MyLOG
