open UtilsLib.Style

let color_value = function
  | Standard, Black -> "Black"
  | Standard, Red -> "DarkRed"
  | Standard, Green -> "Green"
  | Standard, Yellow -> "Orange"
  | Standard, Blue -> "DarkBlue"
  | Standard, Magenta -> "DarkMagenta"
  | Standard, Cyan -> "DarkCyan"
  | Standard, White -> "LightGray"
  | High, Black -> "DarkGray"
  | High, Red -> "Red"
  | High, Green -> "Lime"
  | High, Yellow -> "Yellow"
  | High, Blue -> "Blue"
  | High, Magenta -> "Magenta"
  | High, Cyan -> "Cyan"
  | High, White -> "White"

let rendering_to_html = function
  | No -> ""
  | Bold -> "font-weight: bold"
  | Faint -> "opacity: 0.7"
  | Italic -> "font-style: italic"
  | Underline -> "text-decoration-line: underline"
  | FG (Code c) -> Printf.sprintf "color: %s" (color_value c)
  | FG (RGB (r, g, b)) -> Printf.sprintf "color: rgb(%i, %i, %i)" r g b
  | BG (Code c) -> Printf.sprintf "background-color: %s" (color_value c)
  | BG (RGB (r, g, b)) -> Printf.sprintf "background-color: rgb(%i, %i, %i)" r g b

let render_att = function
  | Open s -> Printf.sprintf "<span style=\"%s\">" (rendering_to_html s)
  | Close _ -> Printf.sprintf "</span>"

let render_mark att = 
  let buff = Buffer.create 2 in
  let () =
    List.iter (fun a -> Buffer.add_string buff (render_att a)) att in
  Buffer.contents buff
