open Js_of_ocaml

open Interface

let () =
  Acgtk_interface.init ();
  Worker.set_onmessage
    (fun message ->
      match message with
      | Messages.ExecCommand (command, max_cols) ->
        Acgtk_interface.execute_command command max_cols
      | Messages.GetEnv max_cols ->
        Acgtk_interface.get_env max_cols;
      | Messages.ClearEnv ->
        Acgtk_interface.clear_env ();
      | Messages.CompileGrammar grammar ->
        Acgtk_interface.compile_grammar grammar)
