(** This module contains functions that perform ACGtk actions, such as compiling
    a grammar or executing a command. It maintains a state that persists between
    calls, that contains the ACGtk environment (type [Scripting.Environment.env]). *)

val init : unit -> unit
(** [init] is a function that must be called before using the other functions. *)

val execute_command : string -> int -> unit
(** [execute_command command max_cols] execute the ACGtk command [command]. The
    answer text is sent back using [Postmessage_formatter] with the message
    [Message.OutputText]. [max_cols] is used to setup this formatter, it should
    be the current width of the text box that will contains the answer text. The
    message [Messages.ExecCommandDone] will be sent when all computations are
    done and all answer text has been sent. *)

val compile_grammar : string -> unit
(** [compile_grammar grammar] checks and compiles the grammar [grammar]. When
    this is done (successfully or not), the message
    [Messages.CompileGrammarDone res] is sent. [res] contains information about
    success or failure. *)

val get_env : int -> unit
(** [get_env max_cols] sends the content of the environment as text using
    [Postmessage_formatter] with the message [Message.OutputEnvText]. [max_cols]
    is used to setup this formatter, it should be the current width of the text
    box that will contains the answer text. *)

val clear_env : unit -> unit
(** [clear_env ()] clear the current ACGtk environment. *)
