open Js_of_ocaml

let f message =
  let buffer = Buffer.create 100 in
  let add_text str = Buffer.add_string buffer str in
  let flush_line () =
    let line = Buffer.contents buffer in
    Worker.post_message (message line);
    Buffer.clear buffer in
  let out_string str s e =
    let text = String.sub str s e in
    add_text text in
  let out_flush _ = () in
  let out_newline _ = flush_line () in
  let out_spaces n = out_string (String.make n ' ') 0 n in
  let out_indent n = out_string (String.make n ' ') 0 n in
  let out_functions = Format.get_formatter_out_functions () in
  Format.formatter_of_out_functions Format.{ out_functions with out_string ; out_flush ; out_newline ; out_spaces ; out_indent } [@warning "-23"] (* this is for compatibility with ocaml 5.4+ and 5.3- where out_width doesn't exists *)
