(** This module defines a formatter which sends the text with the Web Worker 
    Postmessage API. *)

val f : (string -> Messages.answer) -> Format.formatter
(** [f msg] builds a formatter which sends the text to output with the Web Worker API.
    [msg] is a function that is called to transform the text to the actual value that
    will be sent. The Web Worker receiving this value is responsible for displaying
    the text. *)
