open Js_of_ocaml
open Js_of_ocaml_tyxml.Tyxml_js

let textarea =
  Html.(div ~a:[ a_class [ "textarea" ; "fill" ; "pad_6" ] ] [])
let textarea_dom = To_dom.of_div textarea

let resize () =
  let width = textarea_dom##.clientWidth in
  let max_cols = Float.to_int (Float.of_int width /. 7.21668) - 2 in
  Interface.set_max_output_cols max_cols

let add_line line =
  ignore (textarea_dom##appendChild (To_dom.of_node (Js_utils.line_to_html line)));
  textarea_dom##.scrollTop := Js.number_of_float (float_of_int (textarea_dom##.scrollHeight))

let init () =
  resize ()
