(** This module implements the answer text box. *)

val init : unit -> unit
(** [init ()] should be called after the page is fully set up. *)

val textarea :
  [> Html_types.div ] Js_of_ocaml_tyxml.Tyxml_js.Html.elt
(** [textarea] is an HTML div that displays the output of ACGtk. *)

val add_line : string -> unit
(** [add_line text] adds the line of text [text] in [textarea]. [text] may
  contain HTML code which will be interpreted. The purpose of this function is
  to be called by the interface with the web worker which performs the actual
  ACG computations. *)

val resize : unit -> unit
(** [resize ()] sets the max output width depending on the actual width of
  [textarea]. It should be called when the window is resized. *)
