open Js_of_ocaml
open Js_of_ocaml_tyxml.Tyxml_js

let input =
  Html.(input ~a:[ a_class [ "fill" ] ; a_placeholder "Command..." ; a_spellcheck false ] ())
let input_dom = To_dom.of_input input

let button =
  Html.(button [ txt "Execute" ])
let button_dom = To_dom.of_button button

let execute () =
  let command = Js.to_string input_dom##.value in
  if String.trim command <> "" then
    ignore (Grammar.compile
      (fun () ->
        (State.set_state State.Executing;
        input_dom##.value := Js.string "";
        History.add command;
        Interface.exec_command command)))

let stop () =
  Interface.restart ();
  State.set_state State.Idle

let input_key event =
  let key = Js_utils.get_event_key event in
  let command_input_dom =
    Js.Opt.get (Js.Opt.bind event##.target (fun e -> Dom_html.CoerceTo.input (Dom_html.element e))) (fun () -> assert false) in
  if key = Js.string "Enter" then
    (execute ();
    Js._true)
  else if key = Js.string "ArrowUp" then
    (History.move 1 command_input_dom;
    Js._false)
  else if key = Js.string "ArrowDown" then
    (History.move (-1) command_input_dom;
    Js._false)
  else
    Js._true

let update_callback state =
  match state with
  | State.Idle ->
    button_dom##.onclick := Dom_html.handler (fun _ -> execute (); Js._true);
    button_dom##.textContent := Js.some (Js.string "Execute");
    button_dom##.disabled := Js._false
  | State.Compiling ->
    button_dom##.textContent := Js.some (Js.string "Execute");
    button_dom##.disabled := Js._true
  | State.Executing ->
    button_dom##.onclick := Dom_html.handler (fun _ -> stop (); Js._true);
    button_dom##.textContent := Js.some (Js.string "Stop");
    button_dom##.disabled := Js._false

let execute_callback () =
  State.set_state State.Idle

let init () =
  button_dom##.onclick := Dom_html.handler (fun _ -> execute (); Js._true);
  input_dom##.onkeydown := Dom_html.handler input_key
