(** This module implements the command input box. *)

val init : unit -> unit
(** [init ()] should be called before the page is set up. *)

val input :
  [> Html_types.input ] Js_of_ocaml_tyxml.Tyxml_js.Html.elt
(** [input] is an HTML input that the user uses to enter ACG commands. *)

val button :
  [> Html_types.button ] Js_of_ocaml_tyxml.Tyxml_js.Html.elt
(** [button] is an HTML button that submits the current command. *)

val update_callback : State.state -> unit

val execute_callback : unit -> unit
