open Js_of_ocaml
open Js_of_ocaml_tyxml.Tyxml_js

let textarea =
  Html.(div ~a:[ a_class [ "textarea" ; "fill" ; "pad_6" ] ] [ div [] ])
let textarea_dom = To_dom.of_div textarea

let add_line line =
  ignore (textarea_dom##appendChild (To_dom.of_node (Js_utils.line_to_html line)));
  textarea_dom##.scrollTop := Js.number_of_float (float_of_int (textarea_dom##.scrollHeight))

let update () =
  Js_utils.replace_children textarea_dom [];
  Interface.get_env ()

let clear _ =
  Interface.clear_env ();
  ignore (Grammar.force_compile (fun () -> ()));
  true

let clear_button =
  Html.(button ~a:[ a_onclick clear ] [ txt "Clear" ])
