(** This module implements the environment text box. *)

val textarea :
  [> Html_types.div ] Js_of_ocaml_tyxml.Tyxml_js.Html.elt
(** [textarea] is an HTML div that displays the current ACG environment. *)

val clear_button :
  [> Html_types.button ] Js_of_ocaml_tyxml.Tyxml_js.Html.elt
(** [clear_button] is a button HTML element that clears the ACG environment and
  reload it from the current grammar. *)

val add_line : string -> unit
(** [add_line text] adds the line of text [text] in [textarea]. [text] may
  contain HTML code which will be interpreted. The purpose of this function is
  to be called by the interface with the web worker when updating the
  environment. *)

val update : unit -> unit
(** [update ()] updates the text in [textarea] to the current ACG environment.
  It should be called when the current ACG environment may have been modified. *)
