(** This module manages the history of the commands submitted by the user. *)

val add : string -> unit
(** [add command] adds [command] in the history, and resets the current
  position. *)

val move : int -> Js_of_ocaml.Dom_html.inputElement Js_of_ocaml.Js.t -> unit
(** [move n input] change the current position of the history by [n], and
  replace [input] current text with the command at the new position. *)
