open Js_of_ocaml

let worker = ref (Worker.create "")

let url = ref ""
let onmessage = ref (fun _ -> ())

let restart_compile = ref (fun () -> ())

let max_cols = ref 0

let start () =
  worker := Worker.create !url;
  !worker##.onmessage :=
    Dom.handler (fun event ->
      let answer = event##.data in
      !onmessage answer;
      Js._true)

let restart () =
  !worker##terminate;
  start ();
  !restart_compile ()

let init compile_callback answer_callback environment_callback execute_callback restart_callback =
  let script = Js_utils.get_embedded_script "script[type='text/js-worker']" in
  url := Js_utils.generate_blob script;
  onmessage := (fun answer ->
    (match answer with
    | Messages.CompileGrammarDone result -> compile_callback result
    | Messages.OutputText text -> answer_callback text
    | Messages.OutputEnvText text -> environment_callback text
    | Messages.ExecCommandDone -> execute_callback ()));
  restart_compile := restart_callback;
  start ()

let exec_command command =
  !worker##postMessage (Messages.ExecCommand (command, !max_cols))

let get_env () =
  !worker##postMessage (Messages.GetEnv !max_cols)

let clear_env () =
  !worker##postMessage Messages.ClearEnv

let compile_grammar grammar =
  !worker##postMessage (Messages.CompileGrammar grammar)

let set_max_output_cols max =
  max_cols := max
