(** This module manages the status of compilation and execution tasks. *)

type state = Idle | Compiling | Executing
(** The type [state] describe the current action. *)

val init : (state -> unit) -> unit
(** [init callback] should be called before the page is set up. [callback] is
  a function which will be called at each state change. *)

val set_state : state -> unit
(** [set_state state] update the current state to [state]. It will also call the
  callback function that was supplied to [init]. *)
