open Js_of_ocaml
open Js_of_ocaml_tyxml.Tyxml_js

open Gui

let page_body =
  Html. (body ~a:[ a_class [ "flex_v" ] ]
    [ div ~a:[ a_class [ "flex_h" ; "fill" ; "textarea_container" ; "pad_6" ] ]
      [ div ~a:[ a_class [ "flex_v" ; "fill_60" ; "textarea_container" ] ]
        [ Grammar.textarea
        ; div ~a:[ a_class [ "flex_h" ; "flex_space" ] ]
          [ div
            [ Grammar.load_button
            ; Grammar.load_input
            ; Grammar.save_button ]
          ; div ~a:[ a_class [ "flex_h" ; "flex_space" ] ]
            [ Grammar.info
            ; Grammar.compile_button ]
          ]
        ]
      ; div ~a:[ a_class [ "flex_v" ; "fill_40" ; "textarea_container" ] ]
        [ div ~a:[ a_class [ "flex_v" ; "fill_25" ; "textarea_container" ] ]
          [ div ~a:[ a_class [ "flex_h" ; "flex_space" ] ]
            [ txt "Current environment:"
            ; Environment.clear_button ]
          ; Environment.textarea ]
        ; div ~a:[ a_class [ "flex_v" ; "fill_75" ; "textarea_container" ]]
          [ Answer.textarea
          ; div ~a:[ a_class [ "flex_h" ] ]
            [ Command.input
            ; Command.button ]
          ]
        ]
      ]
    ])

let onload _ =
  Grammar.init Environment.update;
  Command.init ();
  State.init (fun s -> Grammar.update_callback s; Command.update_callback s);
  Interface.init Grammar.compile_callback Answer.add_line Environment.add_line Command.execute_callback (fun () -> Grammar.force_compile (fun () -> ()));
  let body = To_dom.of_body page_body in
  let root = Dom_html.getElementById "html" in
  let old_body = Dom_html.getElementById "dummy_body" in
  Dom.replaceChild root body old_body;
  Dom_html.window##.onresize := Dom_html.handler (fun _ -> Answer.resize (); Js._true);
  Answer.init ();
  Js._false

let () =
  Dom_html.window##.onload := Dom_html.handler onload
