open Tyxml

(* This program generates an executable that writes a file with skeleton HTML
   containing a given CSS code and Javascript code. *)

let css =
  let css_file = In_channel.open_text Sys.argv.(1) in
  In_channel.input_all css_file

let acgjs =
  let js_file = In_channel.open_text Sys.argv.(2) in
  In_channel.input_all js_file

let webgui =
  let js_file = In_channel.open_text Sys.argv.(3) in
  In_channel.input_all js_file

let page = 
  Html.(html ~a:[ a_id "html" ; a_spellcheck false ]
    (head (title (txt "ACGtk"))
      [ (script (Unsafe.data webgui))
      ; (script ~a:[ a_script_type (`Mime "text/js-worker") ] (Unsafe.data acgjs))
      ; style [txt css]
      ])
    (body ~a:[ a_id "dummy_body" ] [ h1 [ (txt "Loading...") ]])
  )

let () =
  Format.fprintf Format.std_formatter "%a@." (Html.pp ()) page
