open Logic.Expand
open UtilsLib

let a0 = Address.make_add []

let a1 = Address.make_add [0;1;0]

let a2 = Address.make_add [1] 

let a3 = Address.make_add [1; 0 ; 0 ;1; 1]

let s1 = AddSet.(empty |> add a1 |> add a2 |> add a3)


let s2 = AddSet.(empty |> add a0 |> add a1 |> add a3)

let set_pp fmt s =
  AddSet.iter (fun add -> Format.fprintf fmt "@[\"%a\"@]@," Address.pp add) s

let check a s =
  let in_pp fmt = 
    if AddSet.mem a s then
      Tags.red_pp fmt "in"
    else
      Format.fprintf fmt "%a in" Tags.red_pp "not" in
  Format.printf "Checking: address \"%a\" is %t the set @[<v>%a@]@," Address.pp a in_pp set_pp s
    [@@alert "-deprecated"]


let () = Fmt_tty.setup_std_outputs ~utf_8:true ~style_renderer:`Ansi_tty ()
let () = Tags.add_marking ~render_mark:ANSI_Rendering.render_mark Format.std_formatter

let () = check a0 s1
let () = check a1 s1
let () = check a2 s1
let () = check a3 s1
let () = check a0 s2
let () = check a1 s2
let () = check a2 s2
let () = check a3 s2

let _ = Address.make_add [0;1;2]
